<?php
/**
 * Verificar se usuário está bloqueado
 * INCLUIR ESTE ARQUIVO NO INÍCIO DE TODAS AS PÁGINAS PROTEGIDAS
 */

// Iniciar sessão se ainda não iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Se não estiver logado, redirecionar para autenticação
if (!isset($_SESSION['user_id'])) {
    header('Location: /mensagem/autenticacao/');
    exit;
}

require_once __DIR__ . '/config.php';

try {
    $conn = getConnection();
    
    // Verificar se o usuário está bloqueado
    $stmt = $conn->prepare("SELECT bloqueado FROM usuarios WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$usuario) {
        // Usuário não encontrado, destruir sessão
        session_destroy();
        header('Location: /mensagem/autenticacao/');
        exit;
    }
    
    if (isset($usuario['bloqueado']) && $usuario['bloqueado'] == 1) {
        // Usuário bloqueado, destruir sessão e deletar tokens
        
        // Deletar tokens de auto-login
        $stmt = $conn->prepare("DELETE FROM login_tokens WHERE user_id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        
        // Deletar cookie de auto-login
        if (isset($_COOKIE['auto_login_token'])) {
            setcookie('auto_login_token', '', time() - 3600, '/');
        }
        
        // Destruir sessão
        session_destroy();
        
        // Redirecionar para autenticação com mensagem de erro
        header('Location: /mensagem/autenticacao/?erro=bloqueado');
        exit;
    }
    
} catch (PDOException $e) {
    error_log("Erro ao verificar sessão: " . $e->getMessage());
    // Em caso de erro, permitir acesso (não bloquear por erro de banco)
}
?>
