<?php
/**
 * Verificar eventos Kwai enviados
 */

$conn = new mysqli('localhost', 'gabr5027_mensagem', 'Kakekikoku18@', 'gabr5027_mensagem');

if ($conn->connect_error) {
    die("Erro de conexão");
}

$conn->set_charset('utf8mb4');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificar Eventos Kwai</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #667eea;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background: #667eea;
            color: white;
            font-weight: 600;
        }
        tr:hover {
            background: #f9f9f9;
        }
        .success {
            color: #28a745;
            font-weight: bold;
        }
        .error {
            color: #dc3545;
            font-weight: bold;
        }
        .badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
        }
        .badge-success {
            background: #d4edda;
            color: #155724;
        }
        .badge-danger {
            background: #f8d7da;
            color: #721c24;
        }
        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
        }
        .stat-number {
            font-size: 36px;
            font-weight: bold;
        }
        .stat-label {
            font-size: 14px;
            opacity: 0.9;
        }
        .info-box {
            background: #e7f3ff;
            border-left: 4px solid #2196F3;
            padding: 15px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>📊 Eventos Kwai - Dashboard</h1>
        
        <?php
        // Estatísticas
        $stats = $conn->query("
            SELECT 
                COUNT(*) as total,
                SUM(success) as sucessos,
                COUNT(DISTINCT user_id) as usuarios,
                COUNT(DISTINCT event_name) as tipos_eventos
            FROM kwai_events_log
        ")->fetch_assoc();
        ?>
        
        <div class="stats">
            <div class="stat-card">
                <div class="stat-number"><?php echo $stats['total'] ?? 0; ?></div>
                <div class="stat-label">Total de Eventos</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo $stats['sucessos'] ?? 0; ?></div>
                <div class="stat-label">Eventos Enviados com Sucesso</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo $stats['usuarios'] ?? 0; ?></div>
                <div class="stat-label">Usuários Únicos</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo $stats['tipos_eventos'] ?? 0; ?></div>
                <div class="stat-label">Tipos de Eventos</div>
            </div>
        </div>
        
        <div class="info-box">
            <strong>ℹ️ Dica:</strong> Os eventos com sucesso = 1 foram enviados com sucesso para a API do Kwai.
        </div>
        
        <h2>📋 Últimos Eventos Enviados</h2>
        
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Usuário</th>
                    <th>Evento</th>
                    <th>Click ID</th>
                    <th>Status</th>
                    <th>Data/Hora</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $result = $conn->query("
                    SELECT 
                        e.*,
                        u.username,
                        u.whatsapp
                    FROM kwai_events_log e
                    LEFT JOIN usuarios u ON e.user_id = u.id
                    ORDER BY e.created_at DESC
                    LIMIT 50
                ");
                
                if ($result && $result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        $statusClass = $row['success'] ? 'badge-success' : 'badge-danger';
                        $statusText = $row['success'] ? '✅ Sucesso' : '❌ Falha';
                        
                        echo "<tr>";
                        echo "<td>#{$row['id']}</td>";
                        echo "<td>" . ($row['username'] ?? 'ID: ' . $row['user_id']) . "<br><small>{$row['whatsapp']}</small></td>";
                        echo "<td><strong>{$row['event_name']}</strong></td>";
                        echo "<td><small>" . substr($row['click_id'], 0, 20) . "...</small></td>";
                        echo "<td><span class='badge {$statusClass}'>{$statusText}</span></td>";
                        echo "<td>" . date('d/m/Y H:i:s', strtotime($row['created_at'])) . "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='6' style='text-align: center; padding: 40px;'>
                        Nenhum evento registrado ainda.<br>
                        <small>Faça um teste acessando: <a href='../autenticacao/?click_id=TESTE_123'>../autenticacao/?click_id=TESTE_123</a></small>
                    </td></tr>";
                }
                ?>
            </tbody>
        </table>
        
        <h2>👥 Usuários com Click ID</h2>
        
        <table>
            <thead>
                <tr>
                    <th>Usuário</th>
                    <th>WhatsApp</th>
                    <th>Click ID</th>
                    <th>Capturado em</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $result = $conn->query("
                    SELECT 
                        k.*,
                        u.username,
                        u.whatsapp
                    FROM kwai_tracking k
                    LEFT JOIN usuarios u ON k.user_id = u.id
                    ORDER BY k.updated_at DESC
                    LIMIT 20
                ");
                
                if ($result && $result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>{$row['username']}</td>";
                        echo "<td>{$row['whatsapp']}</td>";
                        echo "<td><small>" . $row['click_id'] . "</small></td>";
                        echo "<td>" . date('d/m/Y H:i:s', strtotime($row['updated_at'])) . "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='4' style='text-align: center; padding: 40px;'>
                        Nenhum click_id capturado ainda.
                    </td></tr>";
                }
                ?>
            </tbody>
        </table>
        
        <p style="margin-top: 30px; text-align: center; color: #666;">
            <a href="?refresh=1" style="color: #667eea; text-decoration: none; font-weight: bold;">🔄 Atualizar</a>
        </p>
    </div>
</body>
</html>
<?php $conn->close(); ?>
