<?php
/**
 * API para upload de áudio
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

// Validações
if (!isset($_FILES['audio'])) {
    echo json_encode(['success' => false, 'message' => 'Arquivo de áudio não fornecido']);
    exit;
}

$file = $_FILES['audio'];
$error = $file['error'];

// Verificar erro no upload
if ($error !== UPLOAD_ERR_OK) {
    echo json_encode(['success' => false, 'message' => 'Erro ao fazer upload do arquivo']);
    exit;
}

$fileSize = $file['size'];
$fileTmpName = $file['tmp_name'];
$fileName = $file['name'];
$fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

// Validar tipo de arquivo
$allowedExtensions = ['webm', 'ogg', 'mp3', 'wav', 'm4a'];

if (!in_array($fileExtension, $allowedExtensions)) {
    echo json_encode(['success' => false, 'message' => 'Formato de áudio não permitido. Use: WebM, OGG, MP3, WAV ou M4A']);
    exit;
}

// Validar tamanho (5MB máximo para 2 minutos de áudio)
$maxSize = 5 * 1024 * 1024; // 5MB

if ($fileSize > $maxSize) {
    echo json_encode(['success' => false, 'message' => 'Áudio muito grande. Máximo 5MB']);
    exit;
}

// Gerar nome único para o arquivo
$uniqueName = uniqid() . '_' . time() . '.' . $fileExtension;
$uploadDir = '../uploads/chat/';

// Criar diretório se não existir
if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

$uploadPath = $uploadDir . $uniqueName;
$relativePath = 'uploads/chat/' . $uniqueName;

// Mover arquivo para diretório final
if (move_uploaded_file($fileTmpName, $uploadPath)) {
    echo json_encode([
        'success' => true,
        'path' => $relativePath,
        'type' => 'audio',
        'filename' => $uniqueName
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Erro ao salvar arquivo']);
}
?>
