<?php
/**
 * Script para adicionar campo de saldo e chave PIX
 * Execute este arquivo UMA VEZ para atualizar a estrutura do banco
 */

require_once 'config.php';

try {
    $conn = getConnection();
    
    // Verifica se a coluna saldo já existe
    $stmt = $conn->query("SHOW COLUMNS FROM usuarios LIKE 'saldo'");
    $saldoExists = $stmt->rowCount() > 0;
    
    if (!$saldoExists) {
        // Adiciona as colunas de saldo e PIX
        $sql = "ALTER TABLE usuarios 
                ADD COLUMN saldo DECIMAL(10, 2) DEFAULT 0.00 AFTER perfil_completo,
                ADD COLUMN chave_pix VARCHAR(255) NULL AFTER saldo,
                ADD COLUMN tipo_chave_pix ENUM('cpf', 'cnpj', 'email', 'telefone', 'aleatorio') NULL AFTER chave_pix";
        
        $conn->exec($sql);
        
        echo json_encode([
            'success' => true,
            'message' => 'Colunas adicionadas com sucesso! (saldo, chave_pix, tipo_chave_pix)'
        ]);
    } else {
        echo json_encode([
            'success' => true,
            'message' => 'As colunas já existem no banco de dados!'
        ]);
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao atualizar tabela: ' . $e->getMessage()
    ]);
}
?>
