<?php
/**
 * Script para adicionar campos ao perfil do usuário
 * Execute este arquivo UMA VEZ para atualizar a estrutura do banco
 */

require_once 'config.php';

try {
    $conn = getConnection();
    
    // Verifica se as colunas já existem
    $stmt = $conn->query("SHOW COLUMNS FROM usuarios LIKE 'foto_perfil'");
    $fotoExists = $stmt->rowCount() > 0;
    
    if (!$fotoExists) {
        // Adiciona as novas colunas
        $sql = "ALTER TABLE usuarios 
                ADD COLUMN foto_perfil VARCHAR(255) NULL AFTER whatsapp,
                ADD COLUMN idade INT NULL AFTER foto_perfil,
                ADD COLUMN sexo ENUM('masculino', 'feminino', 'outro') NULL AFTER idade,
                ADD COLUMN perfil_completo TINYINT(1) DEFAULT 0 AFTER sexo";
        
        $conn->exec($sql);
        
        echo json_encode([
            'success' => true,
            'message' => 'Colunas adicionadas com sucesso! (foto_perfil, idade, sexo, perfil_completo)'
        ]);
    } else {
        echo json_encode([
            'success' => true,
            'message' => 'As colunas já existem no banco de dados!'
        ]);
    }
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao atualizar tabela: ' . $e->getMessage()
    ]);
}
?>
