<?php
/**
 * Script para adicionar campo last_seen na tabela usuarios
 * Execute este arquivo UMA VEZ acessando-o pelo navegador
 */

require_once 'config.php';

try {
    $conn = getConnection();
    
    // Verificar se o campo já existe
    $stmt = $conn->query("SHOW COLUMNS FROM usuarios LIKE 'last_seen'");
    $columnExists = $stmt->rowCount() > 0;
    
    if ($columnExists) {
        echo "ℹ️ Campo 'last_seen' já existe no banco de dados!<br>";
        echo "Nenhuma alteração necessária.<br>";
    } else {
        // Adicionar campo last_seen
        $conn->exec("
            ALTER TABLE usuarios 
            ADD COLUMN last_seen TIMESTAMP NULL DEFAULT NULL
        ");
        
        echo "✅ Campo 'last_seen' adicionado com sucesso!<br>";
        echo "Este campo armazena o último acesso do usuário para determinar se está online.<br>";
    }
    
    echo "<br>Agora você pode fechar esta aba.";
    
} catch (PDOException $e) {
    echo "❌ Erro: " . $e->getMessage();
}
?>
