<?php
/**
 * API para atualizar status online do usuário
 */

require_once 'config_global.php';
initSession();

// Verificar se está logado
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'Usuário não autenticado'
    ]);
    exit;
}

try {
    $conn = getConnection();
    $user_id = $_SESSION['user_id'];
    
    // Atualizar último acesso (considera online se acessou nos últimos 2 minutos)
    $stmt = $conn->prepare("
        UPDATE usuarios 
        SET last_seen = NOW()
        WHERE id = :user_id
    ");
    
    $stmt->execute([':user_id' => $user_id]);
    
    echo json_encode([
        'success' => true,
        'timestamp' => time()
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao atualizar status: ' . $e->getMessage()
    ]);
}
?>
