<?php
/**
 * API para desbloquear usuário
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$user_id = $_SESSION['user_id'];
$blocked_user_id = $_POST['blocked_user_id'] ?? null;

if (!$blocked_user_id) {
    echo json_encode(['success' => false, 'message' => 'ID do usuário bloqueado não fornecido']);
    exit;
}

try {
    $conn = getConnection();
    
    // Remover bloqueio
    $stmt = $conn->prepare("
        DELETE FROM bloqueios 
        WHERE user_id = ? AND blocked_user_id = ?
    ");
    
    $stmt->execute([$user_id, $blocked_user_id]);
    
    if ($stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => 'Usuário desbloqueado com sucesso'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Bloqueio não encontrado'
        ]);
    }
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
