<?php
session_start();
require_once 'config.php';

// Forçar usuário 11 para teste
$_SESSION['user_id'] = 11;

try {
    $conn = getConnection();
    
    echo "<h2>Teste de conexão e saldo</h2>";
    
    // Verificar se a tabela existe
    $stmt = $conn->query("SHOW TABLES LIKE 'saldo'");
    $exists = $stmt->fetch();
    
    if ($exists) {
        echo "<p style='color: green;'>✓ Tabela saldo existe</p>";
        
        // Tentar buscar saldo
        $stmt = $conn->prepare("SELECT saldo FROM saldo WHERE user_id = ?");
        $stmt->execute([11]);
        $result = $stmt->fetch();
        
        if ($result) {
            echo "<p>Saldo do usuário 11: R$ " . number_format($result['saldo'], 2, ',', '.') . "</p>";
        } else {
            echo "<p style='color: orange;'>⚠ Usuário 11 não tem registro na tabela saldo</p>";
            
            // Tentar criar
            echo "<p>Tentando criar registro...</p>";
            $stmt = $conn->prepare("INSERT INTO saldo (user_id, saldo) VALUES (?, 0.00)");
            $stmt->execute([11]);
            echo "<p style='color: green;'>✓ Registro criado com sucesso!</p>";
        }
        
    } else {
        echo "<p style='color: red;'>✗ Tabela saldo NÃO existe!</p>";
        echo "<p>Tabelas disponíveis:</p><ul>";
        
        $stmt = $conn->query("SHOW TABLES");
        while ($table = $stmt->fetch(PDO::FETCH_NUM)) {
            echo "<li>" . $table[0] . "</li>";
        }
        echo "</ul>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Erro: " . $e->getMessage() . "</p>";
}
?>
