<?php
/**
 * Teste de envio de presente com detalhamento de erros
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require_once 'config.php';

// Forçar usuário logado
$_SESSION['user_id'] = 11;

echo "<h2>Teste de Envio de Presente</h2>";

try {
    $conn = getConnection();
    
    // Listar usuários disponíveis
    echo "<h3>Usuários Disponíveis:</h3>";
    $stmt = $conn->query("SELECT id, nome FROM usuarios ORDER BY id LIMIT 10");
    $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<ul>";
    foreach ($usuarios as $user) {
        echo "<li>ID {$user['id']}: {$user['nome']}</li>";
    }
    echo "</ul>";
    
    // Usar os dois primeiros usuários diferentes para o teste
    if (count($usuarios) < 2) {
        throw new Exception("Precisa de pelo menos 2 usuários cadastrados");
    }
    
    $remetente_id = 11;
    $destinatario_id = $usuarios[0]['id'] == 11 ? $usuarios[1]['id'] : $usuarios[0]['id'];
    $valor = 5.00;
    $mensagem = "Teste de presente";
    
    echo "<hr>";
    echo "<p><strong>Dados do Teste:</strong></p>";
    echo "<ul>";
    echo "<li>Remetente: $remetente_id</li>";
    echo "<li>Destinatário: $destinatario_id</li>";
    echo "<li>Valor: R$ " . number_format($valor, 2, ',', '.') . "</li>";
    echo "<li>Mensagem: $mensagem</li>";
    echo "</ul>";
    $conn->beginTransaction();
    
    echo "<p style='color: blue;'>✓ Conexão estabelecida</p>";
    echo "<p style='color: blue;'>✓ Transação iniciada</p>";
    
    // Verificar saldo do remetente
    echo "<p>Verificando saldo do remetente...</p>";
    $stmt = $conn->prepare("SELECT id, nome, saldo FROM usuarios WHERE id = ?");
    $stmt->execute([$remetente_id]);
    $remetente = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$remetente) {
        throw new Exception("Remetente não encontrado");
    }
    
    echo "<p style='color: green;'>✓ Remetente: {$remetente['nome']}</p>";
    echo "<p style='color: green;'>✓ Saldo atual: R$ " . number_format($remetente['saldo'], 2, ',', '.') . "</p>";
    
    $saldo_atual = floatval($remetente['saldo']);
    
    // Verificar destinatário
    echo "<p>Verificando destinatário...</p>";
    $stmt = $conn->prepare("SELECT id, nome, saldo FROM usuarios WHERE id = ?");
    $stmt->execute([$destinatario_id]);
    $destinatario = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$destinatario) {
        throw new Exception("Destinatário não encontrado");
    }
    
    echo "<p style='color: green;'>✓ Destinatário: {$destinatario['nome']}</p>";
    echo "<p style='color: green;'>✓ Saldo destinatário: R$ " . number_format($destinatario['saldo'], 2, ',', '.') . "</p>";
    
    // Verificar saldo suficiente
    if ($saldo_atual < $valor) {
        throw new Exception("Saldo insuficiente. Disponível: R$ " . number_format($saldo_atual, 2, ',', '.'));
    }
    
    echo "<p style='color: green;'>✓ Saldo suficiente</p>";
    
    // Atualizar saldos
    echo "<p>Atualizando saldos...</p>";
    $novo_saldo_remetente = $saldo_atual - $valor;
    $stmt = $conn->prepare("UPDATE usuarios SET saldo = ? WHERE id = ?");
    $stmt->execute([$novo_saldo_remetente, $remetente_id]);
    
    echo "<p style='color: green;'>✓ Saldo deduzido do remetente</p>";
    
    $stmt = $conn->prepare("UPDATE usuarios SET saldo = saldo + ? WHERE id = ?");
    $stmt->execute([$valor, $destinatario_id]);
    
    echo "<p style='color: green;'>✓ Saldo adicionado ao destinatário</p>";
    
    // Criar/obter conversa
    echo "<p>Verificando conversa...</p>";
    $stmt = $conn->prepare("
        SELECT id FROM conversas 
        WHERE (user1_id = ? AND user2_id = ?) 
           OR (user1_id = ? AND user2_id = ?)
    ");
    $stmt->execute([$remetente_id, $destinatario_id, $destinatario_id, $remetente_id]);
    $conversa = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$conversa) {
        echo "<p style='color: orange;'>⚠ Criando nova conversa...</p>";
        $stmt = $conn->prepare("
            INSERT INTO conversas (user1_id, user2_id, ultima_mensagem_at) 
            VALUES (?, ?, NOW())
        ");
        $stmt->execute([$remetente_id, $destinatario_id]);
        $conversa_id = $conn->lastInsertId();
        echo "<p style='color: green;'>✓ Conversa criada: ID $conversa_id</p>";
    } else {
        $conversa_id = $conversa['id'];
        echo "<p style='color: green;'>✓ Conversa existente: ID $conversa_id</p>";
    }
    
    // Inserir mensagem
    echo "<p>Salvando mensagem de presente...</p>";
    $stmt = $conn->prepare("
        INSERT INTO mensagens (conversa_id, remetente_id, destinatario_id, mensagem, tipo_midia, gift_amount, created_at)
        VALUES (?, ?, ?, ?, 'gift', ?, NOW())
    ");
    $stmt->execute([$conversa_id, $remetente_id, $destinatario_id, $mensagem, $valor]);
    $mensagem_id = $conn->lastInsertId();
    
    echo "<p style='color: green;'>✓ Mensagem salva: ID $mensagem_id</p>";
    
    // Registrar no histórico
    echo "<p>Registrando no histórico...</p>";
    $stmt = $conn->prepare("
        INSERT INTO saldo_historico (user_id, tipo, valor, descricao, created_at)
        VALUES (?, 'gift_sent', ?, ?, NOW())
    ");
    $descricao_remetente = "Presente enviado para {$destinatario['nome']}";
    $stmt->execute([$remetente_id, -$valor, $descricao_remetente]);
    
    $stmt = $conn->prepare("
        INSERT INTO saldo_historico (user_id, tipo, valor, descricao, created_at)
        VALUES (?, 'gift_received', ?, ?, NOW())
    ");
    $descricao_destinatario = "Presente recebido de {$remetente['nome']}";
    $stmt->execute([$destinatario_id, $valor, $descricao_destinatario]);
    
    echo "<p style='color: green;'>✓ Histórico registrado</p>";
    
    // Commit
    $conn->commit();
    
    echo "<hr>";
    echo "<h3 style='color: green;'>✅ Presente enviado com sucesso!</h3>";
    echo "<p>Novo saldo do remetente: R$ " . number_format($novo_saldo_remetente, 2, ',', '.') . "</p>";
    
} catch (Exception $e) {
    if (isset($conn) && $conn->inTransaction()) {
        $conn->rollBack();
        echo "<p style='color: orange;'>⚠ Transação revertida</p>";
    }
    
    echo "<hr>";
    echo "<h3 style='color: red;'>❌ Erro!</h3>";
    echo "<p style='color: red;'>" . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>
