<?php
/**
 * Teste de debug para get_or_create_conversation
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

echo "<h2>Debug Session</h2>";
echo "Session ID: " . session_id() . "<br>";
echo "User ID na sessão: " . (isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 'NÃO DEFINIDO') . "<br><br>";

echo "<h2>Debug POST</h2>";
echo "POST user_id: " . (isset($_POST['user_id']) ? $_POST['user_id'] : 'NÃO ENVIADO') . "<br><br>";

require_once 'config.php';

try {
    $conn = getConnection();
    echo "<h2>Conexão OK</h2>";
    
    if (isset($_POST['user_id']) && isset($_SESSION['user_id'])) {
        $current_user_id = $_SESSION['user_id'];
        $other_user_id = intval($_POST['user_id']);
        
        echo "Current User: $current_user_id<br>";
        echo "Other User: $other_user_id<br><br>";
        
        // Verificar se conversa já existe
        $stmt = $conn->prepare("
            SELECT id FROM conversas 
            WHERE (user1_id = :user1 AND user2_id = :user2)
            OR (user1_id = :user2 AND user2_id = :user1)
        ");
        $stmt->execute([
            ':user1' => $current_user_id,
            ':user2' => $other_user_id
        ]);
        
        $conversa = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($conversa) {
            echo "Conversa existente ID: " . $conversa['id'] . "<br>";
        } else {
            echo "Nenhuma conversa encontrada. Tentando criar...<br>";
            
            $user1 = min($current_user_id, $other_user_id);
            $user2 = max($current_user_id, $other_user_id);
            
            echo "Inserindo: user1=$user1, user2=$user2<br>";
            
            $stmt = $conn->prepare("
                INSERT INTO conversas (user1_id, user2_id) 
                VALUES (:user1, :user2)
            ");
            $stmt->execute([
                ':user1' => $user1,
                ':user2' => $user2
            ]);
            
            echo "Conversa criada! ID: " . $conn->lastInsertId() . "<br>";
        }
        
    } else {
        echo "<strong>ERRO: Dados ausentes</strong><br>";
    }
    
} catch (PDOException $e) {
    echo "<h2>ERRO SQL:</h2>";
    echo $e->getMessage();
}
?>
