<?php
/**
 * Script de teste e diagnóstico
 */

// Configurações do banco
$host = 'localhost';
$dbname = 'gabr5027_mensagem';
$user = 'gabr5027_mensagem';
$pass = 'Kakekikoku18@';

echo "<h2>🔍 Diagnóstico do Sistema</h2>";
echo "<hr>";

// Teste 1: Conexão com o banco
echo "<h3>1. Testando conexão com o banco de dados...</h3>";
try {
    $conn = new PDO(
        "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $user,
        $pass,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    echo "✅ <strong>Conexão estabelecida com sucesso!</strong><br>";
} catch(PDOException $e) {
    echo "❌ <strong>Erro na conexão:</strong> " . $e->getMessage() . "<br>";
    echo "<p>Verifique:</p>";
    echo "<ul>";
    echo "<li>Se o banco de dados 'gabr5027_mensagem' existe no phpMyAdmin</li>";
    echo "<li>Se o usuário 'gabr5027_mensagem' tem permissões</li>";
    echo "<li>Se a senha está correta</li>";
    echo "</ul>";
    exit;
}

echo "<hr>";

// Teste 2: Verificar se a tabela existe
echo "<h3>2. Verificando se a tabela 'usuarios' existe...</h3>";
try {
    $stmt = $conn->query("SHOW TABLES LIKE 'usuarios'");
    $tableExists = $stmt->rowCount() > 0;
    
    if ($tableExists) {
        echo "✅ <strong>Tabela 'usuarios' encontrada!</strong><br>";
        
        // Mostrar estrutura da tabela
        echo "<h4>Estrutura da tabela:</h4>";
        $stmt = $conn->query("DESCRIBE usuarios");
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        while ($row = $stmt->fetch()) {
            echo "<tr>";
            echo "<td>{$row['Field']}</td>";
            echo "<td>{$row['Type']}</td>";
            echo "<td>{$row['Null']}</td>";
            echo "<td>{$row['Key']}</td>";
            echo "<td>{$row['Default']}</td>";
            echo "<td>{$row['Extra']}</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Contar usuários
        $stmt = $conn->query("SELECT COUNT(*) as total FROM usuarios");
        $total = $stmt->fetch()['total'];
        echo "<br><strong>Total de usuários cadastrados:</strong> $total<br>";
        
        // Listar usuários (se houver)
        if ($total > 0) {
            echo "<h4>Usuários cadastrados:</h4>";
            $stmt = $conn->query("SELECT id, nome, whatsapp, created_at FROM usuarios ORDER BY id DESC");
            echo "<table border='1' cellpadding='5'>";
            echo "<tr><th>ID</th><th>Nome</th><th>WhatsApp</th><th>Cadastrado em</th></tr>";
            while ($row = $stmt->fetch()) {
                echo "<tr>";
                echo "<td>{$row['id']}</td>";
                echo "<td>{$row['nome']}</td>";
                echo "<td>{$row['whatsapp']}</td>";
                echo "<td>{$row['created_at']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
        
    } else {
        echo "❌ <strong>Tabela 'usuarios' NÃO encontrada!</strong><br>";
        echo "<p>➡️ <a href='setup_database.php'>Clique aqui para criar a tabela</a></p>";
    }
} catch(PDOException $e) {
    echo "❌ <strong>Erro:</strong> " . $e->getMessage();
}

echo "<hr>";

// Teste 3: Verificar versão do PHP e extensões
echo "<h3>3. Informações do servidor:</h3>";
echo "<strong>Versão do PHP:</strong> " . phpversion() . "<br>";
echo "<strong>PDO disponível:</strong> " . (extension_loaded('pdo') ? '✅ Sim' : '❌ Não') . "<br>";
echo "<strong>PDO MySQL disponível:</strong> " . (extension_loaded('pdo_mysql') ? '✅ Sim' : '❌ Não') . "<br>";

echo "<hr>";
echo "<p><strong>📌 Próximos passos:</strong></p>";
echo "<ul>";
echo "<li>Se a tabela não existe, execute o <a href='setup_database.php'>setup_database.php</a></li>";
echo "<li>Após criar a tabela, volte para a <a href='../autenticacao/index.html'>página de cadastro</a></li>";
echo "<li>Depois de testar, você pode deletar este arquivo (test.php) por segurança</li>";
echo "</ul>";
?>

<style>
    body {
        font-family: Arial, sans-serif;
        max-width: 900px;
        margin: 20px auto;
        padding: 20px;
        background: #f5f5f5;
    }
    h2 { color: #059669; }
    h3 { color: #333; margin-top: 20px; }
    table {
        background: white;
        border-collapse: collapse;
        width: 100%;
        margin: 10px 0;
    }
    th {
        background: #059669;
        color: white;
        padding: 8px;
    }
    td {
        padding: 8px;
    }
    a {
        color: #059669;
        font-weight: bold;
    }
</style>
