<?php
/**
 * API para marcar usuário como offline imediatamente
 */

session_start();

require_once 'config.php';

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$user_id = $_SESSION['user_id'];

try {
    $conn = getConnection();
    
    // Marcar como offline definindo last_seen para data muito antiga
    // Assim o usuário sai da lista de online imediatamente
    $stmt = $conn->prepare("
        UPDATE usuarios 
        SET last_seen = DATE_SUB(NOW(), INTERVAL 5 MINUTE)
        WHERE id = ?
    ");
    
    $stmt->execute([$user_id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Usuário marcado como offline'
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
