<?php
/**
 * Liberar saque bloqueado após pagamento da taxa
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$user_id = $_SESSION['user_id'];

try {
    $conn = getConnection();
    
    // Buscar saque bloqueado mais recente do usuário
    $stmt = $conn->prepare("
        SELECT id, valor 
        FROM saques 
        WHERE user_id = :user_id AND status = 'bloqueado'
        ORDER BY created_at DESC 
        LIMIT 1
    ");
    
    $stmt->execute([':user_id' => $user_id]);
    $saque = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$saque) {
        echo json_encode([
            'success' => false,
            'message' => 'Nenhum saque bloqueado encontrado'
        ]);
        exit;
    }
    
    // Atualizar status do saque para "processando"
    $stmt = $conn->prepare("
        UPDATE saques 
        SET status = 'processando' 
        WHERE id = :saque_id
    ");
    
    $stmt->execute([':saque_id' => $saque['id']]);
    
    // Marcar que o usuário pagou a taxa e pode fazer 1 saque grátis
    $_SESSION['taxa_paga'] = true;
    $_SESSION['taxa_paga_time'] = time();
    
    // NÃO debitar saldo aqui - apenas marcar como processando
    // O saldo será debitado quando o saque for aprovado via painel admin
    // ou quando o usuário pagar a colaboração e liberar o saque
    
    echo json_encode([
        'success' => true,
        'message' => 'Saque marcado como processando!',
        'data' => [
            'saque_id' => $saque['id'],
            'valor' => $saque['valor']
        ]
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
