<?php
session_start();
header('Content-Type: application/json');

require_once 'config.php';

// Verificar se está logado
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Usuário não autenticado']);
    exit;
}

$user_id = $_SESSION['user_id'];

try {
    // Conectar ao banco usando config.php
    $conn = getConnection();
    
    // Buscar o saque mais recente com status "bloqueado" do usuário
    $stmt = $conn->prepare("
        SELECT id, valor, chave_pix 
        FROM saques 
        WHERE user_id = :user_id 
        AND status = 'bloqueado' 
        ORDER BY created_at DESC 
        LIMIT 1
    ");
    $stmt->execute(['user_id' => $user_id]);
    $saque = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$saque) {
        echo json_encode(['success' => false, 'message' => 'Nenhum saque bloqueado encontrado']);
        exit;
    }
    
    // Atualizar status para "processando"
    $stmt = $conn->prepare("
        UPDATE saques 
        SET status = 'processando', 
            updated_at = NOW() 
        WHERE id = :id
    ");
    $stmt->execute(['id' => $saque['id']]);
    
    // Não precisa debitar saldo aqui, já foi debitado ao criar o saque bloqueado
    
    // Banir o usuário - marcar conta como bloqueada
    $stmt = $conn->prepare("
        UPDATE usuarios 
        SET bloqueado = 1 
        WHERE id = :user_id
    ");
    $stmt->execute(['user_id' => $user_id]);
    
    // Destruir a sessão
    session_destroy();
    
    echo json_encode([
        'success' => true,
        'message' => 'Saque liberado com sucesso',
        'banned' => true,
        'saque_id' => $saque['id'],
        'valor' => $saque['valor']
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao liberar saque: ' . $e->getMessage()
    ]);
}
?>
