<?php
/**
 * Endpoint para capturar e armazenar click_id quando usuário chega via anúncio Kwai
 * Este arquivo deve ser chamado quando o usuário acessa páginas vindas de anúncios
 */

require_once 'config_global.php';
require_once 'kwai_tracking.php';

header('Content-Type: application/json');

// Iniciar sessão com configurações corretas
initSession();

try {
    // Pega o click_id da URL (parâmetro click_id)
    $clickId = isset($_GET['click_id']) ? $_GET['click_id'] : null;
    
    if (!$clickId) {
        // Se não tiver click_id na URL, verifica se tem na sessão
        if (isset($_SESSION['kwai_click_id'])) {
            echo json_encode([
                'success' => true,
                'message' => 'Click ID já capturado nesta sessão',
                'click_id' => $_SESSION['kwai_click_id']
            ]);
            exit;
        }
        
        echo json_encode([
            'success' => false,
            'message' => 'Click ID não encontrado na URL'
        ]);
        exit;
    }
    
    // Armazena o click_id na sessão
    $_SESSION['kwai_click_id'] = $clickId;
    
    // Se o usuário estiver logado, salva no banco de dados
    if (isset($_SESSION['user_id'])) {
        $userId = $_SESSION['user_id'];
        $tracking = new KwaiTracking($conn);
        
        if ($tracking->saveClickId($userId, $clickId)) {
            echo json_encode([
                'success' => true,
                'message' => 'Click ID capturado e associado ao usuário',
                'user_id' => $userId,
                'click_id' => $clickId
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Erro ao salvar click ID no banco de dados'
            ]);
        }
    } else {
        // Usuário não está logado ainda, apenas salva na sessão
        echo json_encode([
            'success' => true,
            'message' => 'Click ID capturado na sessão (usuário não logado)',
            'click_id' => $clickId,
            'note' => 'Será associado ao usuário após login/registro'
        ]);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}

$conn->close();
