<?php
/**
 * API para buscar histórico de saques do usuário
 */

require_once 'config_global.php';
initSession();

// Verificar autenticação
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'Usuário não autenticado'
    ]);
    exit;
}

$user_id = $_SESSION['user_id'];

try {
    $conn = getConnection();
    
    // Buscar saques do usuário
    $stmt = $conn->prepare("
        SELECT 
            id,
            valor,
            status,
            created_at,
            updated_at
        FROM saques 
        WHERE user_id = :user_id 
        ORDER BY created_at DESC
        LIMIT 50
    ");
    
    $stmt->execute([':user_id' => $user_id]);
    $saques = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Formatar datas
    foreach ($saques as &$saque) {
        $saque['valor'] = floatval($saque['valor']);
        $saque['created_at_formatted'] = date('d/m/Y H:i', strtotime($saque['created_at']));
    }
    
    echo json_encode([
        'success' => true,
        'saques' => $saques
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar histórico: ' . $e->getMessage()
    ]);
}
?>
