<?php
/**
 * API para buscar perfil de um usuário específico
 */

session_start();

require_once 'config.php';

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$user_id = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;

if ($user_id <= 0) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'ID de usuário inválido']);
    exit;
}

try {
    $conn = getConnection();
    
    // Buscar dados do usuário
    $stmt = $conn->prepare("
        SELECT 
            id,
            nome,
            idade,
            sexo,
            foto_perfil,
            last_seen,
            TIMESTAMPDIFF(SECOND, last_seen, NOW()) as segundos_offline
        FROM usuarios 
        WHERE id = ?
        AND perfil_completo = 1
    ");
    
    $stmt->execute([$user_id]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$usuario) {
        http_response_code(404);
        echo json_encode(['success' => false, 'message' => 'Usuário não encontrado']);
        exit;
    }
    
    // Verificar se está online (visto nos últimos 30 segundos)
    $usuario['online'] = $usuario['segundos_offline'] <= 30;
    
    // Remover dados desnecessários
    unset($usuario['last_seen']);
    unset($usuario['segundos_offline']);
    
    echo json_encode([
        'success' => true,
        'user' => $usuario
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar perfil: ' . $e->getMessage()
    ]);
}
?>
