<?php
/**
 * API simplificada para obter dados básicos do usuário
 */

require_once 'config_global.php';
initSession();

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'Usuário não autenticado'
    ]);
    exit;
}

try {
    $conn = getConnection();
    $userId = $_SESSION['user_id'];
    
    $stmt = $conn->prepare("
        SELECT 
            id,
            nome,
            whatsapp,
            foto_perfil,
            idade,
            sexo,
            saldo,
            is_member,
            chave_pix,
            tipo_chave_pix,
            perfil_completo
        FROM usuarios 
        WHERE id = ?
    ");
    
    $stmt->execute([$userId]);
    $user = $stmt->fetch();
    
    if (!$user) {
        http_response_code(404);
        echo json_encode([
            'success' => false,
            'message' => 'Usuário não encontrado'
        ]);
        exit;
    }
    
    echo json_encode([
        'success' => true,
        'user' => [
            'id' => $user['id'],
            'nome' => $user['nome'],
            'whatsapp' => $user['whatsapp'],
            'foto_perfil' => getUploadUrl($user['foto_perfil']),
            'idade' => $user['idade'],
            'sexo' => $user['sexo'],
            'saldo' => floatval($user['saldo']),
            'is_member' => (bool)$user['is_member'],
            'chave_pix' => $user['chave_pix'],
            'tipo_chave_pix' => $user['tipo_chave_pix'],
            'perfil_completo' => (bool)$user['perfil_completo']
        ]
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar dados: ' . $e->getMessage()
    ]);
}
