<?php
/**
 * API para obter dados do usuário logado
 */

require_once 'config_global.php';
initSession();

// Verificar se está logado
if (!isset($_SESSION['user_id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Usuário não autenticado'
    ]);
    exit;
}

try {
    $conn = getConnection();
    $userId = $_SESSION['user_id'];
    
    // Buscar dados do usuário
    $stmt = $conn->prepare("
        SELECT id, nome, whatsapp, foto_perfil, idade, sexo, perfil_completo, saldo, chave_pix, tipo_chave_pix, is_member, created_at
        FROM usuarios 
        WHERE id = ?
    ");
    
    $stmt->execute([$userId]);
    $usuario = $stmt->fetch();
    
    if (!$usuario) {
        http_response_code(404);
        echo json_encode([
            'success' => false,
            'message' => 'Usuário não encontrado'
        ]);
        exit;
    }
    
    echo json_encode([
        'success' => true,
        'user' => [
            'id' => $usuario['id'],
            'nome' => $usuario['nome'],
            'whatsapp' => $usuario['whatsapp'],
            'foto_perfil' => $usuario['foto_perfil'],
            'idade' => $usuario['idade'],
            'sexo' => $usuario['sexo'],
            'perfil_completo' => (bool)$usuario['perfil_completo'],
            'saldo' => (float)$usuario['saldo'],
            'chave_pix' => $usuario['chave_pix'],
            'tipo_chave_pix' => $usuario['tipo_chave_pix'],
            'is_member' => (bool)$usuario['is_member'],
            'membro_desde' => $usuario['created_at']
        ]
    ]);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar dados: ' . $e->getMessage()
    ]);
}
?>
