<?php
/**
 * API para buscar usuários online
 */

require_once 'config_global.php';
initSession();

// Verificar se está logado
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'Usuário não autenticado'
    ]);
    exit;
}

// Pegar filtro de gênero
$filtro = $_GET['filtro'] ?? 'todos';

try {
    $conn = getConnection();
    $user_id = $_SESSION['user_id'];
    
    // Montar query base (considera online se visto nos últimos 30 segundos)
    // Com heartbeat a cada 10s, 30s é tempo suficiente para detectar saída
    $sql = "
        SELECT 
            u.id,
            u.nome,
            u.idade,
            u.sexo,
            u.foto_perfil,
            u.last_seen,
            TIMESTAMPDIFF(SECOND, u.last_seen, NOW()) as segundos_offline,
            COUNT(DISTINCT m.id) as nao_lidas
        FROM usuarios u
        LEFT JOIN mensagens m ON m.remetente_id = u.id 
            AND m.destinatario_id = :user_id 
            AND m.lida = 0
        WHERE u.id != :user_id_filter
        AND u.perfil_completo = 1
        AND u.last_seen >= DATE_SUB(NOW(), INTERVAL 30 SECOND)
    ";
    
    // Adicionar filtro de gênero
    if ($filtro !== 'todos') {
        $sql .= " AND u.sexo = :sexo";
    }
    
    $sql .= " GROUP BY u.id ORDER BY nao_lidas DESC, u.last_seen DESC LIMIT 50";
    
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':user_id', $user_id, PDO::PARAM_INT);
    $stmt->bindValue(':user_id_filter', $user_id, PDO::PARAM_INT);
    
    if ($filtro !== 'todos') {
        $stmt->bindValue(':sexo', $filtro, PDO::PARAM_STR);
    }
    
    $stmt->execute();
    $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Formatar dados
    $total_nao_lidas = 0;
    foreach ($usuarios as &$usuario) {
        $usuario['idade'] = (int)$usuario['idade'];
        $usuario['nao_lidas'] = (int)$usuario['nao_lidas'];
        $usuario['online'] = true;
        $total_nao_lidas += $usuario['nao_lidas'];
        unset($usuario['last_seen']);
        unset($usuario['segundos_offline']);
    }
    
    echo json_encode([
        'success' => true,
        'usuarios' => $usuarios,
        'total' => count($usuarios),
        'total_nao_lidas' => $total_nao_lidas
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar usuários: ' . $e->getMessage()
    ]);
}
?>
