<?php
/**
 * API para deletar mensagem
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$user_id = $_SESSION['user_id'];

// Ler dados JSON
$input = file_get_contents('php://input');
$data = json_decode($input, true);

$message_id = isset($data['message_id']) ? intval($data['message_id']) : 0;

if (!$message_id) {
    echo json_encode(['success' => false, 'message' => 'ID da mensagem inválido']);
    exit;
}

try {
    $conn = getConnection();
    
    // Verificar se a mensagem pertence ao usuário
    $stmt = $conn->prepare("SELECT remetente_id FROM mensagens WHERE id = ?");
    $stmt->execute([$message_id]);
    $message = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$message) {
        echo json_encode(['success' => false, 'message' => 'Mensagem não encontrada']);
        exit;
    }
    
    if ($message['remetente_id'] != $user_id) {
        echo json_encode(['success' => false, 'message' => 'Você não pode deletar esta mensagem']);
        exit;
    }
    
    // Deletar a mensagem
    $stmt = $conn->prepare("DELETE FROM mensagens WHERE id = ?");
    $stmt->execute([$message_id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Mensagem deletada com sucesso'
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
