<?php
/**
 * Teste da API de registro - Debug Mode
 */

// Log de debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Headers
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Log para arquivo
$logFile = __DIR__ . '/debug.log';
$logData = [
    'timestamp' => date('Y-m-d H:i:s'),
    'method' => $_SERVER['REQUEST_METHOD'],
    'headers' => getallheaders(),
    'raw_input' => file_get_contents('php://input'),
    'post_data' => $_POST,
    'get_data' => $_GET
];

file_put_contents($logFile, json_encode($logData, JSON_PRETTY_PRINT) . "\n\n", FILE_APPEND);

// Mostra o que foi recebido
echo json_encode([
    'debug' => true,
    'received_method' => $_SERVER['REQUEST_METHOD'],
    'raw_input' => file_get_contents('php://input'),
    'decoded_json' => json_decode(file_get_contents('php://input'), true),
    'post_data' => $_POST,
    'content_type' => $_SERVER['CONTENT_TYPE'] ?? 'not set',
    'log_saved' => 'Check debug.log file'
], JSON_PRETTY_PRINT);
?>
