<?php
/**
 * Debug: Ver todas mensagens não lidas
 */

session_start();
require_once 'config.php';

if (!isset($_SESSION['user_id'])) {
    echo "Não autenticado";
    exit;
}

$user_id = $_SESSION['user_id'];

try {
    $conn = getConnection();
    
    // Todas mensagens não lidas
    $stmt = $conn->prepare("
        SELECT 
            m.*,
            u.nome as remetente_nome
        FROM mensagens m
        LEFT JOIN usuarios u ON m.remetente_id = u.id
        WHERE m.destinatario_id = ?
        AND m.lida = 0
        ORDER BY m.created_at DESC
    ");
    
    $stmt->execute([$user_id]);
    $mensagens = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h2>User ID: $user_id</h2>";
    echo "<h3>Total mensagens não lidas: " . count($mensagens) . "</h3>";
    echo "<pre>";
    print_r($mensagens);
    echo "</pre>";
    
    echo "<hr>";
    echo "<h3>Session Storage last_check simulado:</h3>";
    echo "<p>Timestamp 10 segundos atrás: " . date('Y-m-d H:i:s', strtotime('-10 seconds')) . "</p>";
    
} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage();
}
?>
