<?php
/**
 * Debug - Ver mensagens com mídia
 */

session_start();
require_once 'config.php';

$conversa_id = $_GET['id'] ?? 1;

echo "<h2>Debug - Mensagens da Conversa ID: $conversa_id</h2>";

try {
    $conn = getConnection();
    
    $stmt = $conn->prepare("
        SELECT 
            m.*,
            u.nome as remetente_nome
        FROM mensagens m
        LEFT JOIN usuarios u ON m.remetente_id = u.id
        WHERE m.conversa_id = ?
        ORDER BY m.created_at DESC
        LIMIT 10
    ");
    $stmt->execute([$conversa_id]);
    $mensagens = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<p>Total de mensagens: " . count($mensagens) . "</p>";
    
    if (count($mensagens) > 0) {
        echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr>";
        echo "<th>ID</th>";
        echo "<th>De</th>";
        echo "<th>Mensagem</th>";
        echo "<th>Tipo Mídia</th>";
        echo "<th>Caminho Mídia</th>";
        echo "<th>Preview</th>";
        echo "<th>Data</th>";
        echo "</tr>";
        
        foreach ($mensagens as $msg) {
            echo "<tr>";
            echo "<td>{$msg['id']}</td>";
            echo "<td>{$msg['remetente_nome']}</td>";
            echo "<td>" . htmlspecialchars($msg['mensagem']) . "</td>";
            echo "<td>" . ($msg['tipo_midia'] ?? 'N/A') . "</td>";
            echo "<td>" . ($msg['caminho_midia'] ?? 'N/A') . "</td>";
            echo "<td>";
            
            if ($msg['tipo_midia'] === 'image' && $msg['caminho_midia']) {
                echo "<img src='/mensagem/{$msg['caminho_midia']}' style='max-width: 150px;'>";
            } elseif ($msg['tipo_midia'] === 'video' && $msg['caminho_midia']) {
                echo "<video src='/mensagem/{$msg['caminho_midia']}' controls style='max-width: 150px;'></video>";
            } else {
                echo "Sem mídia";
            }
            
            echo "</td>";
            echo "<td>{$msg['created_at']}</td>";
            echo "</tr>";
        }
        
        echo "</table>";
    } else {
        echo "<p>Nenhuma mensagem encontrada.</p>";
    }
    
    // Verificar estrutura da tabela
    echo "<hr><h3>Estrutura da Tabela mensagens:</h3>";
    $stmt = $conn->query("SHOW COLUMNS FROM mensagens");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<pre>";
    foreach ($columns as $col) {
        echo $col['Field'] . " - " . $col['Type'] . "\n";
    }
    echo "</pre>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>ERRO: " . $e->getMessage() . "</p>";
}
?>
