<?php
/**
 * Debug do send_gift.php
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'config.php';

session_start();

echo "<h1>Debug - Send Gift</h1>";

// 1. Verificar sessão
echo "<h2>1. Sessão</h2>";
if (isset($_SESSION['user_id'])) {
    echo "<p style='color: green;'>✓ Usuário autenticado: ID = {$_SESSION['user_id']}</p>";
} else {
    echo "<p style='color: red;'>✗ Usuário NÃO autenticado</p>";
    exit;
}

// 2. Verificar estrutura da tabela mensagens
echo "<h2>2. Estrutura da tabela mensagens</h2>";
try {
    $conn = getConnection();
    $stmt = $conn->query("DESCRIBE mensagens");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Default</th></tr>";
    
    $has_gift_amount = false;
    foreach ($columns as $col) {
        echo "<tr>";
        echo "<td>{$col['Field']}</td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Null']}</td>";
        echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
        
        if ($col['Field'] === 'gift_amount') {
            $has_gift_amount = true;
        }
    }
    echo "</table>";
    
    if ($has_gift_amount) {
        echo "<p style='color: green;'>✓ Coluna gift_amount existe</p>";
    } else {
        echo "<p style='color: red;'>✗ Coluna gift_amount NÃO existe</p>";
        echo "<p><a href='migrate_gifts.php'>→ Executar migração</a></p>";
    }
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>Erro: " . $e->getMessage() . "</p>";
}

// 3. Verificar tabela saldo_historico
echo "<h2>3. Tabela saldo_historico</h2>";
try {
    $stmt = $conn->query("SHOW TABLES LIKE 'saldo_historico'");
    $tableExists = $stmt->fetch();
    
    if ($tableExists) {
        echo "<p style='color: green;'>✓ Tabela saldo_historico existe</p>";
        
        $stmt = $conn->query("DESCRIBE saldo_historico");
        $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
        echo "<tr><th>Campo</th><th>Tipo</th><th>Null</th><th>Default</th></tr>";
        foreach ($columns as $col) {
            echo "<tr>";
            echo "<td>{$col['Field']}</td>";
            echo "<td>{$col['Type']}</td>";
            echo "<td>{$col['Null']}</td>";
            echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: red;'>✗ Tabela saldo_historico NÃO existe</p>";
        echo "<p><a href='migrate_gifts.php'>→ Executar migração</a></p>";
    }
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>Erro: " . $e->getMessage() . "</p>";
}

// 4. Verificar saldo do usuário
echo "<h2>4. Saldo do usuário</h2>";
try {
    $stmt = $conn->prepare("SELECT saldo FROM saldo WHERE user_id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $saldo = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($saldo) {
        echo "<p>Saldo atual: <strong>R$ " . number_format($saldo['saldo'], 2, ',', '.') . "</strong></p>";
    } else {
        echo "<p style='color: orange;'>⚠ Nenhum saldo encontrado</p>";
    }
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>Erro: " . $e->getMessage() . "</p>";
}

// 5. Testar INSERT na tabela mensagens com gift_amount
echo "<h2>5. Teste de INSERT</h2>";
try {
    // Simular dados de teste
    $test_remetente = $_SESSION['user_id'];
    $test_destinatario = $_SESSION['user_id']; // Para teste, mesmo usuário
    $test_valor = 5.00;
    $test_mensagem = "Teste de presente";
    
    echo "<p>Tentando inserir mensagem de presente de teste...</p>";
    
    // Buscar ou criar conversa
    $stmt = $conn->prepare("
        SELECT id FROM conversas 
        WHERE (user1_id = ? AND user2_id = ?) 
           OR (user1_id = ? AND user2_id = ?)
    ");
    $stmt->execute([$test_remetente, $test_destinatario, $test_destinatario, $test_remetente]);
    $conversa = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($conversa) {
        $conversa_id = $conversa['id'];
        echo "<p>✓ Conversa ID: {$conversa_id}</p>";
    } else {
        echo "<p style='color: orange;'>⚠ Nenhuma conversa encontrada (normal se você nunca conversou consigo mesmo)</p>";
        echo "<p>Teste concluído. Estrutura parece OK.</p>";
    }
    
    echo "<hr>";
    echo "<h2 style='color: green;'>✅ Debug concluído!</h2>";
    echo "<p>Se não houve erros acima, o sistema de presentes deve funcionar.</p>";
    echo "<p><a href='../chat/'>← Voltar ao chat</a></p>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'><strong>✗ ERRO:</strong> " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>
