<?php
/**
 * Debug - Testar busca de mensagens da conversa
 */

session_start();
$_SESSION['admin_authenticated'] = true; // Forçar autenticação para teste

require_once 'config.php';

$conversa_id = $_GET['id'] ?? 4;

echo "<h2>Debug - Mensagens da Conversa ID: $conversa_id</h2>";

try {
    $conn = getConnection();
    
    // 1. Verificar se a conversa existe
    echo "<h3>1. Verificar Conversa</h3>";
    $stmt = $conn->prepare("SELECT * FROM conversas WHERE id = ?");
    $stmt->execute([$conversa_id]);
    $conversa = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($conversa) {
        echo "<pre>";
        print_r($conversa);
        echo "</pre>";
    } else {
        echo "<p style='color: red;'>Conversa não encontrada!</p>";
        exit;
    }
    
    // 2. Buscar nomes dos usuários
    echo "<h3>2. Usuários da Conversa</h3>";
    $stmt = $conn->prepare("
        SELECT 
            c.user1_id,
            c.user2_id,
            u1.nome as user1_nome,
            u2.nome as user2_nome
        FROM conversas c
        INNER JOIN usuarios u1 ON c.user1_id = u1.id
        INNER JOIN usuarios u2 ON c.user2_id = u2.id
        WHERE c.id = ?
    ");
    $stmt->execute([$conversa_id]);
    $conv_info = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<pre>";
    print_r($conv_info);
    echo "</pre>";
    
    // 3. Buscar mensagens
    echo "<h3>3. Mensagens</h3>";
    $stmt = $conn->prepare("
        SELECT 
            m.id,
            m.sender_id,
            m.mensagem,
            m.created_at,
            u.nome as sender_nome
        FROM mensagens m
        INNER JOIN usuarios u ON m.sender_id = u.id
        WHERE m.conversa_id = ?
        ORDER BY m.created_at ASC
    ");
    $stmt->execute([$conversa_id]);
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<p>Total de mensagens: " . count($messages) . "</p>";
    echo "<pre>";
    print_r($messages);
    echo "</pre>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>ERRO: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>
