<?php
/**
 * Debug - Verificar dados do usuário ID 11
 */

require_once 'config.php';

try {
    $conn = getConnection();
    
    echo "<h2>Verificando Usuário ID 11</h2>";
    
    $stmt = $conn->prepare("SELECT * FROM usuarios WHERE id = 11");
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user) {
        echo "<pre>";
        echo "ID: " . $user['id'] . "\n";
        echo "Nome: " . $user['nome'] . "\n";
        echo "WhatsApp: " . $user['whatsapp'] . "\n";
        echo "Is Admin: " . ($user['is_admin'] ?? 'COLUNA NÃO EXISTE') . "\n";
        echo "Hash da Senha: " . substr($user['senha'], 0, 20) . "...\n";
        echo "\n--- TESTE DE SENHA ---\n";
        
        $senhasTeste = ['Sigm@123', 'sigm@123', 'SIGM@123'];
        foreach ($senhasTeste as $senha) {
            $valida = password_verify($senha, $user['senha']);
            echo "Senha '$senha': " . ($valida ? "✓ VÁLIDA" : "✗ INVÁLIDA") . "\n";
        }
        
        echo "</pre>";
    } else {
        echo "<p style='color: red;'>Usuário ID 11 não encontrado!</p>";
    }
    
    echo "<hr>";
    echo "<h3>Verificar coluna is_admin</h3>";
    $stmt = $conn->query("SHOW COLUMNS FROM usuarios LIKE 'is_admin'");
    $column = $stmt->fetch();
    
    if ($column) {
        echo "<pre>";
        print_r($column);
        echo "</pre>";
    } else {
        echo "<p style='color: red;'>Coluna 'is_admin' NÃO EXISTE na tabela!</p>";
        echo "<p>Execute o arquivo setup_admin.php primeiro!</p>";
    }
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>ERRO: " . $e->getMessage() . "</p>";
}
?>
