<?php
/**
 * Script para criar tabelas de chat
 * Execute este arquivo UMA VEZ acessando-o pelo navegador
 */

require_once 'config.php';

try {
    $conn = getConnection();
    
    // Criar tabela de conversas
    $conn->exec("
        CREATE TABLE IF NOT EXISTS conversas (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user1_id INT NOT NULL,
            user2_id INT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            UNIQUE KEY unique_conversation (user1_id, user2_id),
            FOREIGN KEY (user1_id) REFERENCES usuarios(id) ON DELETE CASCADE,
            FOREIGN KEY (user2_id) REFERENCES usuarios(id) ON DELETE CASCADE,
            INDEX idx_user1 (user1_id),
            INDEX idx_user2 (user2_id)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");
    
    echo "✅ Tabela 'conversas' criada com sucesso!<br>";
    
    // Criar tabela de mensagens
    $conn->exec("
        CREATE TABLE IF NOT EXISTS mensagens (
            id INT AUTO_INCREMENT PRIMARY KEY,
            conversa_id INT NOT NULL,
            remetente_id INT NOT NULL,
            destinatario_id INT NOT NULL,
            mensagem TEXT NOT NULL,
            lida TINYINT(1) DEFAULT 0,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (conversa_id) REFERENCES conversas(id) ON DELETE CASCADE,
            FOREIGN KEY (remetente_id) REFERENCES usuarios(id) ON DELETE CASCADE,
            FOREIGN KEY (destinatario_id) REFERENCES usuarios(id) ON DELETE CASCADE,
            INDEX idx_conversa (conversa_id),
            INDEX idx_lida (lida),
            INDEX idx_created (created_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");
    
    echo "✅ Tabela 'mensagens' criada com sucesso!<br>";
    echo "<br>Sistema de chat configurado! Agora você pode fechar esta aba.";
    
} catch (PDOException $e) {
    echo "❌ Erro: " . $e->getMessage();
}
?>
