<?php
/**
 * Criar saque com status bloqueado (aguardando pagamento de taxa)
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$user_id = $_SESSION['user_id'];
$valor = $_POST['valor'] ?? 0;
$status = $_POST['status'] ?? 'bloqueado';

// Validar valor
$valor = floatval($valor);

if ($valor < 100) {
    echo json_encode([
        'success' => false,
        'message' => 'Valor mínimo para saque é R$ 100,00'
    ]);
    exit;
}

try {
    $conn = getConnection();
    
    // Buscar dados do usuário
    $stmt = $conn->prepare("SELECT saldo, chave_pix FROM usuarios WHERE id = :user_id");
    $stmt->execute([':user_id' => $user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        echo json_encode(['success' => false, 'message' => 'Usuário não encontrado']);
        exit;
    }
    
    // Verificar chave PIX
    if (empty($user['chave_pix'])) {
        echo json_encode(['success' => false, 'message' => 'Cadastre uma chave PIX primeiro']);
        exit;
    }
    
    // Verificar saldo
    if ($user['saldo'] < $valor) {
        echo json_encode(['success' => false, 'message' => 'Saldo insuficiente']);
        exit;
    }
    
    // Criar tabela de saques se não existir
    $conn->exec("
        CREATE TABLE IF NOT EXISTS saques (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            valor DECIMAL(10, 2) NOT NULL,
            chave_pix VARCHAR(255) NOT NULL,
            status VARCHAR(20) DEFAULT 'pendente',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES usuarios(id) ON DELETE CASCADE,
            INDEX idx_user_status (user_id, status)
        )
    ");
    
    // Inserir solicitação de saque com status bloqueado
    $stmt = $conn->prepare("
        INSERT INTO saques (user_id, valor, chave_pix, status) 
        VALUES (:user_id, :valor, :chave_pix, :status)
    ");
    
    $stmt->execute([
        ':user_id' => $user_id,
        ':valor' => $valor,
        ':chave_pix' => $user['chave_pix'],
        ':status' => $status
    ]);
    
    $saque_id = $conn->lastInsertId();
    
    // Debitar o saldo do usuário imediatamente
    $stmt = $conn->prepare("
        UPDATE usuarios 
        SET saldo = saldo - :valor 
        WHERE id = :user_id
    ");
    $stmt->execute([
        ':valor' => $valor,
        ':user_id' => $user_id
    ]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Solicitação criada. Pague a taxa para liberar.',
        'data' => [
            'saque_id' => $saque_id,
            'valor' => $valor,
            'status' => $status
        ]
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
