<?php
/**
 * API para verificar status online de um usuário
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

if (!$user_id) {
    echo json_encode(['success' => false, 'message' => 'ID do usuário não fornecido']);
    exit;
}

try {
    $conn = getConnection();
    
    // Verificar status online (30 segundos de tolerância)
    $stmt = $conn->prepare("
        SELECT 
            TIMESTAMPDIFF(SECOND, last_seen, NOW()) as segundos_offline
        FROM usuarios 
        WHERE id = ?
    ");
    $stmt->execute([$user_id]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result) {
        $online = $result['segundos_offline'] <= 30;
        
        echo json_encode([
            'success' => true,
            'online' => $online,
            'segundos_offline' => (int)$result['segundos_offline']
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Usuário não encontrado'
        ]);
    }
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
