<?php
session_start();
header('Content-Type: application/json');

// Verificar se está logado
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

// Verificar se a taxa foi paga recentemente (últimas 24 horas)
$taxa_paga = false;
if (isset($_SESSION['taxa_paga']) && $_SESSION['taxa_paga'] === true) {
    // Verificar se ainda está dentro do período de 24 horas
    $tempo_desde_pagamento = time() - ($_SESSION['taxa_paga_time'] ?? 0);
    if ($tempo_desde_pagamento < 86400) { // 24 horas em segundos
        $taxa_paga = true;
    } else {
        // Expirou, limpar sessão
        unset($_SESSION['taxa_paga']);
        unset($_SESSION['taxa_paga_time']);
    }
}

echo json_encode([
    'success' => true,
    'taxa_paga' => $taxa_paga
]);
?>
