<?php
/**
 * API para verificar status de leitura das mensagens
 */

session_start();

require_once 'config.php';

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$current_user_id = $_SESSION['user_id'];
$conversa_id = isset($_GET['conversa_id']) ? intval($_GET['conversa_id']) : 0;

if (!$conversa_id) {
    echo json_encode(['success' => false, 'message' => 'ID da conversa não fornecido']);
    exit;
}

try {
    $conn = getConnection();
    
    // Buscar apenas o status de leitura das minhas mensagens lidas
    $stmt = $conn->prepare("
        SELECT id, lida
        FROM mensagens
        WHERE conversa_id = ?
        AND remetente_id = ?
        AND lida = 1
        ORDER BY id DESC
        LIMIT 50
    ");
    $stmt->execute([$conversa_id, $current_user_id]);
    
    $read_status = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'read_messages' => $read_status
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
