<?php
/**
 * API para verificar novas mensagens (polling)
 */

require_once 'config_global.php';
initSession();

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$current_user_id = $_SESSION['user_id'];

try {
    $conn = getConnection();
    
    // Buscar TODAS mensagens não lidas (sem filtro de tempo)
    // O frontend vai controlar quais já foram mostradas
    $stmt = $conn->prepare("
        SELECT 
            m.id,
            m.conversa_id,
            m.remetente_id,
            m.mensagem,
            m.created_at,
            u.nome as remetente_nome,
            u.foto_perfil as remetente_foto
        FROM mensagens m
        LEFT JOIN usuarios u ON m.remetente_id = u.id
        WHERE m.destinatario_id = ?
        AND m.lida = 0
        ORDER BY m.created_at DESC
        LIMIT 10
    ");
    
    $stmt->execute([$current_user_id]);
    $novas_mensagens = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'novas_mensagens' => $novas_mensagens,
        'total' => count($novas_mensagens)
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
