<?php
/**
 * API para verificar novos presentes recebidos
 */

session_start();
require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$current_user_id = $_SESSION['user_id'];

try {
    $conn = getConnection();
    
    // Buscar presentes não lidos
    $stmt = $conn->prepare("
        SELECT 
            m.id,
            m.conversa_id,
            m.remetente_id,
            m.mensagem,
            m.gift_amount,
            m.created_at,
            u.nome as remetente_nome,
            u.foto_perfil as remetente_foto
        FROM mensagens m
        LEFT JOIN usuarios u ON m.remetente_id = u.id
        WHERE m.destinatario_id = ?
        AND m.tipo_midia = 'gift'
        AND m.lida = 0
        ORDER BY m.created_at DESC
    ");
    
    $stmt->execute([$current_user_id]);
    $novos_presentes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Buscar saldo atual do usuário
    $stmt = $conn->prepare("SELECT saldo FROM usuarios WHERE id = ?");
    $stmt->execute([$current_user_id]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'novos_presentes' => $novos_presentes,
        'total' => count($novos_presentes),
        'saldo_atual' => $usuario ? number_format($usuario['saldo'], 2, '.', '') : '0.00'
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar presentes'
    ]);
}
