<?php
/**
 * Script para verificar se FFmpeg está instalado
 */

header('Content-Type: application/json');

$ffmpeg = shell_exec('ffmpeg -version 2>&1');
$ffmpegInstalled = (strpos($ffmpeg, 'ffmpeg version') !== false);

if ($ffmpegInstalled) {
    // Extrair versão
    preg_match('/ffmpeg version ([\d.]+)/', $ffmpeg, $matches);
    $version = $matches[1] ?? 'desconhecida';
    
    echo json_encode([
        'installed' => true,
        'version' => $version,
        'message' => 'FFmpeg está instalado e funcionando',
        'compression' => 'enabled'
    ]);
} else {
    echo json_encode([
        'installed' => false,
        'message' => 'FFmpeg não está instalado',
        'compression' => 'disabled',
        'instructions' => [
            'Windows' => 'Baixe em https://www.gyan.dev/ffmpeg/builds/ e adicione ao PATH',
            'Linux' => 'Execute: sudo apt-get install ffmpeg',
            'MacOS' => 'Execute: brew install ffmpeg'
        ]
    ]);
}
?>
