<?php
/**
 * API para verificar mensagens deletadas
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$conversa_id = isset($_GET['conversa_id']) ? intval($_GET['conversa_id']) : 0;
$message_ids = isset($_GET['message_ids']) ? $_GET['message_ids'] : '';

if (!$conversa_id || !$message_ids) {
    echo json_encode(['success' => true, 'deleted' => []]);
    exit;
}

try {
    $conn = getConnection();
    
    // Converter string de IDs em array
    $ids = explode(',', $message_ids);
    $ids = array_map('intval', $ids);
    $ids = array_filter($ids);
    
    if (empty($ids)) {
        echo json_encode(['success' => true, 'deleted' => []]);
        exit;
    }
    
    // Buscar quais IDs ainda existem
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    $params = array_merge([$conversa_id], $ids);
    
    $stmt = $conn->prepare("
        SELECT id 
        FROM mensagens 
        WHERE conversa_id = ? 
        AND id IN ($placeholders)
    ");
    $stmt->execute($params);
    $existing_ids = $stmt->fetchAll(PDO::FETCH_COLUMN, 0);
    
    // IDs deletados são os que estavam na lista mas não existem mais
    $deleted_ids = array_diff($ids, $existing_ids);
    
    echo json_encode([
        'success' => true,
        'deleted' => array_values($deleted_ids)
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
