<?php
/**
 * API para verificar status de bloqueio
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$user_id = $_SESSION['user_id'];
$other_user_id = $_POST['other_user_id'] ?? null;

if (!$other_user_id) {
    echo json_encode(['success' => false, 'message' => 'ID do usuário não fornecido']);
    exit;
}

try {
    $conn = getConnection();
    
    // Verificar se existe bloqueio
    $stmt = $conn->prepare("
        SELECT COUNT(*) as blocked 
        FROM bloqueios 
        WHERE user_id = ? AND blocked_user_id = ?
    ");
    
    $stmt->execute([$user_id, $other_user_id]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'is_blocked' => $result['blocked'] > 0
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
