<?php
/**
 * API para bloquear usuário
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$user_id = $_SESSION['user_id'];
$blocked_user_id = $_POST['blocked_user_id'] ?? null;

if (!$blocked_user_id) {
    echo json_encode(['success' => false, 'message' => 'ID do usuário bloqueado não fornecido']);
    exit;
}

try {
    $conn = getConnection();
    
    // Criar tabela de bloqueios se não existir
    $conn->exec("
        CREATE TABLE IF NOT EXISTS bloqueios (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            blocked_user_id INT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            UNIQUE KEY unique_block (user_id, blocked_user_id),
            FOREIGN KEY (user_id) REFERENCES usuarios(id) ON DELETE CASCADE,
            FOREIGN KEY (blocked_user_id) REFERENCES usuarios(id) ON DELETE CASCADE
        )
    ");
    
    // Inserir bloqueio
    $stmt = $conn->prepare("
        INSERT INTO bloqueios (user_id, blocked_user_id) 
        VALUES (?, ?)
        ON DUPLICATE KEY UPDATE created_at = CURRENT_TIMESTAMP
    ");
    
    $stmt->execute([$user_id, $blocked_user_id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Usuário bloqueado com sucesso'
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
