<?php
/**
 * API para ativar membership do usuário
 */

require_once __DIR__ . '/config_global.php';
initSession();

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$user_id = $_SESSION['user_id'];

try {
    $conn = getConnection();
    
    // Ativar membership
    $stmt = $conn->prepare("UPDATE usuarios SET is_member = 1 WHERE id = ?");
    $stmt->execute([$user_id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Membership ativado com sucesso!'
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
