<?php
/**
 * API para admin atualizar dados de usuário
 */

session_start();

header('Content-Type: application/json');

// Verificar se é admin
if (!isset($_SESSION['admin_authenticated']) || $_SESSION['admin_authenticated'] !== true) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'Acesso não autorizado'
    ]);
    exit;
}

require_once 'config.php';

try {
    // Validar dados
    if (!isset($_POST['user_id']) || !isset($_POST['nome'])) {
        throw new Exception('Dados incompletos');
    }
    
    $userId = intval($_POST['user_id']);
    $nome = trim($_POST['nome']);
    
    if (empty($nome)) {
        throw new Exception('Nome é obrigatório');
    }
    
    $conn = getConnection();
    
    // Montar query dinamicamente apenas com campos fornecidos
    $updates = ['nome = ?'];
    $params = [$nome];
    
    if (isset($_POST['whatsapp']) && !empty($_POST['whatsapp'])) {
        $updates[] = 'whatsapp = ?';
        $params[] = trim($_POST['whatsapp']);
    }
    
    if (isset($_POST['idade']) && !empty($_POST['idade'])) {
        $idade = intval($_POST['idade']);
        if ($idade < 18 || $idade > 120) {
            throw new Exception('Idade deve estar entre 18 e 120 anos');
        }
        $updates[] = 'idade = ?';
        $params[] = $idade;
    }
    
    if (isset($_POST['sexo']) && !empty($_POST['sexo'])) {
        $sexo = strtolower(trim($_POST['sexo']));
        if (!in_array($sexo, ['masculino', 'feminino', 'outro'])) {
            throw new Exception('Sexo inválido');
        }
        $updates[] = 'sexo = ?';
        $params[] = $sexo;
    }
    
    if (isset($_POST['saldo']) && $_POST['saldo'] !== '') {
        $saldo = floatval($_POST['saldo']);
        if ($saldo < 0) {
            throw new Exception('Saldo não pode ser negativo');
        }
        $updates[] = 'saldo = ?';
        $params[] = $saldo;
    }
    
    if (isset($_POST['senha']) && !empty($_POST['senha'])) {
        $senhaHash = password_hash($_POST['senha'], PASSWORD_DEFAULT);
        $updates[] = 'senha = ?';
        $params[] = $senhaHash;
    }
    
    // Adicionar user_id no final
    $params[] = $userId;
    
    // Executar update
    $sql = "UPDATE usuarios SET " . implode(', ', $updates) . " WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);
    
    if ($stmt->rowCount() === 0) {
        throw new Exception('Nenhuma alteração foi feita ou usuário não encontrado');
    }
    
    // Log da ação
    $changes = [];
    if (isset($_POST['whatsapp'])) $changes[] = 'whatsapp';
    if (isset($_POST['idade'])) $changes[] = 'idade';
    if (isset($_POST['sexo'])) $changes[] = 'sexo';
    if (isset($_POST['saldo'])) $changes[] = 'saldo';
    if (isset($_POST['senha'])) $changes[] = 'senha';
    if (isset($_POST['senha'])) $changes[] = 'senha';
    
    error_log("Admin {$_SESSION['admin_user_name']} atualizou usuário ID {$userId}: nome, " . implode(', ', $changes));
    
    echo json_encode([
        'success' => true,
        'message' => 'Perfil atualizado com sucesso'
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
