<?php
/**
 * API para obter estatísticas do painel admin
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_authenticated'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

try {
    $conn = getConnection();
    
    // Total de usuários
    $stmt = $conn->query("SELECT COUNT(*) as total FROM usuarios");
    $total_users = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
    
    // Total de conversas
    $stmt = $conn->query("SELECT COUNT(*) as total FROM conversas");
    $total_conversations = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
    
    echo json_encode([
        'success' => true,
        'total_users' => $total_users,
        'total_conversations' => $total_conversations
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
