<?php
/**
 * API de login para administrador
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

$whatsapp = $_POST['whatsapp'] ?? '';
$senha = $_POST['password'] ?? '';

// Log para debug
error_log("Admin Login Attempt - WhatsApp: $whatsapp");

if (!$whatsapp || !$senha) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'WhatsApp e senha são obrigatórios'
    ]);
    exit;
}

try {
    $conn = getConnection();
    
    // Buscar usuário pelo WhatsApp
    $stmt = $conn->prepare("
        SELECT id, nome, senha, is_admin, whatsapp
        FROM usuarios 
        WHERE whatsapp = ?
    ");
    $stmt->execute([$whatsapp]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Log para debug
    error_log("User found: " . ($user ? "Yes (ID: {$user['id']}, is_admin: {$user['is_admin']})" : "No"));
    
    if (!$user) {
        http_response_code(401);
        echo json_encode([
            'success' => false,
            'message' => 'Usuário não encontrado'
        ]);
        exit;
    }
    
    // Verificar se é admin
    if (!$user['is_admin']) {
        http_response_code(403);
        echo json_encode([
            'success' => false,
            'message' => 'Acesso negado. Você não é administrador.'
        ]);
        exit;
    }
    
    // Verificar senha
    $senhaValida = password_verify($senha, $user['senha']);
    error_log("Password verify: " . ($senhaValida ? "Valid" : "Invalid"));
    
    if ($senhaValida) {
        $_SESSION['admin_authenticated'] = true;
        $_SESSION['admin_user_id'] = $user['id'];
        $_SESSION['admin_user_name'] = $user['nome'];
        
        echo json_encode([
            'success' => true,
            'message' => 'Login realizado com sucesso',
            'admin_name' => $user['nome']
        ]);
    } else {
        http_response_code(401);
        echo json_encode([
            'success' => false,
            'message' => 'Senha incorreta'
        ]);
    }
    
} catch (PDOException $e) {
    error_log("Admin login error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro no servidor: ' . $e->getMessage()
    ]);
}
?>
