<?php
/**
 * API para obter lista de usuários (admin)
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_authenticated'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

try {
    $conn = getConnection();
    
    $search = $_GET['search'] ?? '';
    
    if ($search) {
        // Buscar com filtro
        $stmt = $conn->prepare("
            SELECT 
                id, 
                nome, 
                whatsapp, 
                foto_perfil, 
                idade, 
                sexo,
                saldo,
                TIMESTAMPDIFF(SECOND, last_seen, NOW()) as segundos_offline
            FROM usuarios 
            WHERE nome LIKE ? OR whatsapp LIKE ?
            ORDER BY last_seen DESC
        ");
        $searchTerm = "%{$search}%";
        $stmt->execute([$searchTerm, $searchTerm]);
    } else {
        // Listar todos
        $stmt = $conn->query("
            SELECT 
                id, 
                nome, 
                whatsapp, 
                foto_perfil, 
                idade, 
                sexo,
                saldo,
                TIMESTAMPDIFF(SECOND, last_seen, NOW()) as segundos_offline
            FROM usuarios 
            ORDER BY last_seen DESC
        ");
    }
    
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'users' => $users
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
