<?php
/**
 * API para obter mensagens de uma conversa (admin)
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_authenticated'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

$conversa_id = isset($_GET['conversa_id']) ? intval($_GET['conversa_id']) : 0;

if (!$conversa_id) {
    echo json_encode(['success' => false, 'message' => 'ID da conversa não fornecido']);
    exit;
}

try {
    $conn = getConnection();
    
    // Log de debug
    error_log("Admin Get Messages - Conversa ID: $conversa_id");
    
    // Buscar informações da conversa
    $stmt = $conn->prepare("
        SELECT 
            c.user1_id,
            c.user2_id,
            u1.nome as user1_nome,
            u2.nome as user2_nome
        FROM conversas c
        INNER JOIN usuarios u1 ON c.user1_id = u1.id
        INNER JOIN usuarios u2 ON c.user2_id = u2.id
        WHERE c.id = ?
    ");
    $stmt->execute([$conversa_id]);
    $conversa = $stmt->fetch(PDO::FETCH_ASSOC);
    
    error_log("Conversa found: " . ($conversa ? "Yes" : "No"));
    
    if (!$conversa) {
        echo json_encode(['success' => false, 'message' => 'Conversa não encontrada']);
        exit;
    }
    
    // Buscar todas as mensagens
    $stmt = $conn->prepare("
        SELECT 
            m.id,
            m.remetente_id as sender_id,
            m.mensagem,
            m.tipo_midia,
            m.caminho_midia,
            m.created_at,
            u.nome as sender_nome,
            CASE 
                WHEN m.remetente_id = ? THEN 1
                ELSE 0
            END as is_sent
        FROM mensagens m
        INNER JOIN usuarios u ON m.remetente_id = u.id
        WHERE m.conversa_id = ?
        ORDER BY m.created_at ASC
    ");
    $stmt->execute([$conversa['user1_id'], $conversa_id]);
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    error_log("Messages found: " . count($messages));
    
    echo json_encode([
        'success' => true,
        'conversa' => $conversa,
        'messages' => $messages
    ]);
    
} catch (PDOException $e) {
    error_log("Admin Get Messages Error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
