<?php
/**
 * API para obter lista de conversas (admin)
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_authenticated'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

try {
    $conn = getConnection();
    
    $stmt = $conn->query("
        SELECT 
            c.id,
            u1.nome as user1_nome,
            u2.nome as user2_nome,
            COUNT(m.id) as total_mensagens,
            MAX(m.created_at) as ultima_mensagem
        FROM conversas c
        INNER JOIN usuarios u1 ON c.user1_id = u1.id
        INNER JOIN usuarios u2 ON c.user2_id = u2.id
        LEFT JOIN mensagens m ON c.id = m.conversa_id
        GROUP BY c.id, u1.nome, u2.nome
        ORDER BY ultima_mensagem DESC
    ");
    
    $conversations = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'conversations' => $conversations
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
