<?php
/**
 * API para excluir usuário e todos seus dados (admin)
 */

session_start();

require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_authenticated'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
$photo_path = $_POST['photo_path'] ?? '';

if (!$user_id) {
    echo json_encode(['success' => false, 'message' => 'ID do usuário não fornecido']);
    exit;
}

try {
    $conn = getConnection();
    $conn->beginTransaction();
    
    // 1. Buscar todas as conversas do usuário
    $stmt = $conn->prepare("
        SELECT id FROM conversas 
        WHERE user1_id = ? OR user2_id = ?
    ");
    $stmt->execute([$user_id, $user_id]);
    $conversas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // 2. Buscar e deletar todos os arquivos de mídia das mensagens
    foreach ($conversas as $conversa) {
        // Buscar mensagens com mídia
        $stmt = $conn->prepare("
            SELECT caminho_midia 
            FROM mensagens 
            WHERE conversa_id = ? AND caminho_midia IS NOT NULL AND caminho_midia != ''
        ");
        $stmt->execute([$conversa['id']]);
        $midias = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Deletar arquivos físicos
        foreach ($midias as $midia) {
            $filePath = "../" . $midia['caminho_midia'];
            if (file_exists($filePath)) {
                unlink($filePath);
            }
        }
        
        // Deletar mensagens
        $stmt = $conn->prepare("DELETE FROM mensagens WHERE conversa_id = ?");
        $stmt->execute([$conversa['id']]);
    }
    
    // 3. Excluir todas as conversas
    $stmt = $conn->prepare("DELETE FROM conversas WHERE user1_id = ? OR user2_id = ?");
    $stmt->execute([$user_id, $user_id]);
    
    // 4. Verificar se a tabela saques existe antes de tentar deletar
    $stmt = $conn->query("SHOW TABLES LIKE 'saques'");
    if ($stmt->rowCount() > 0) {
        $stmt = $conn->prepare("DELETE FROM saques WHERE user_id = ?");
        $stmt->execute([$user_id]);
    }
    
    // 5. Excluir foto de perfil do servidor
    if ($photo_path && file_exists("../{$photo_path}")) {
        unlink("../{$photo_path}");
    }
    
    // 6. Excluir usuário
    $stmt = $conn->prepare("DELETE FROM usuarios WHERE id = ?");
    $stmt->execute([$user_id]);
    
    $conn->commit();
    
    echo json_encode([
        'success' => true,
        'message' => 'Usuário excluído com sucesso'
    ]);
    
} catch (PDOException $e) {
    $conn->rollBack();
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao excluir usuário: ' . $e->getMessage()
    ]);
}
?>
