# Backend - Sistema de Autenticação

## 📋 Estrutura criada:

### Arquivos PHP:
- **config.php** - Configuração do banco de dados e conexão PDO
- **setup_database.php** - Script para criar a tabela de usuários
- **register.php** - API de cadastro de usuários
- **login.php** - API de autenticação
- **check_session.php** - Verifica se usuário está logado
- **logout.php** - Faz logout do usuário

## 🗄️ Banco de Dados:

**Nome:** gabr5027_mensagem  
**Usuário:** gabr5027_mensagem  
**Senha:** Kakekikoku18@

### Tabela: usuarios
```sql
- id (INT, AUTO_INCREMENT, PRIMARY KEY)
- nome (VARCHAR 255)
- whatsapp (VARCHAR 20, UNIQUE)
- senha (VARCHAR 255, hash bcrypt)
- created_at (TIMESTAMP)
- updated_at (TIMESTAMP)
```

## 🚀 Como usar:

### 1. Criar a tabela no banco de dados:
Acesse no navegador: `http://seudominio.com/autenticacao/backend/setup_database.php`

Isso vai criar automaticamente a tabela `usuarios` no banco de dados.

### 2. Testar o sistema:
- O frontend já está integrado com o backend
- Formulário de cadastro envia para `backend/register.php`
- Formulário de login envia para `backend/login.php`

## 🔐 Segurança implementada:

✅ **Hash de senha** com bcrypt  
✅ **Prepared Statements** (proteção contra SQL Injection)  
✅ **Validação de dados** no servidor  
✅ **Headers CORS** configurados  
✅ **Sessões PHP** para autenticação  
✅ **WhatsApp único** (constraint no banco)

## 📝 Endpoints da API:

### POST /backend/register.php
```json
{
  "nome": "João Silva",
  "whatsapp": "11999999999",
  "senha": "minhasenha123"
}
```

### POST /backend/login.php
```json
{
  "whatsapp": "11999999999",
  "senha": "minhasenha123"
}
```

### GET /backend/check_session.php
Retorna se o usuário está logado

### GET /backend/logout.php
Faz logout do usuário

## ⚠️ Importante:

1. Execute `setup_database.php` apenas UMA VEZ
2. Após criar a tabela, você pode deletar o arquivo `setup_database.php` por segurança
3. Configure as permissões corretas da pasta no servidor
4. Certifique-se que o PHP tem suporte a PDO e MySQL
