# Sistema de Saques e Perfil

## 📋 Funcionalidades Implementadas

### Página de Saques (`/saques`)
- ✅ Visualização do saldo disponível
- ✅ Cadastro de chave PIX (CPF, CNPJ, E-mail, Telefone, Aleatória)
- ✅ Solicitação de saque (mínimo R$ 20,00)
- ✅ Histórico de saques com status
- ✅ Validações em tempo real
- ✅ Sistema de notificações

### Página de Perfil (`/perfil`)
- ✅ Visualização dos dados pessoais
- ✅ Upload de foto de perfil
- ✅ Edição de nome, idade e sexo
- ✅ Visualização do saldo
- ✅ Visualização da chave PIX cadastrada
- ✅ Logout

### Header Principal
- ✅ Exibição do saldo ao lado da foto de perfil
- ✅ Atualização automática do saldo

## 🗄️ Banco de Dados

### Tabela `usuarios`
Campos adicionados:
- `saldo` (DECIMAL 10,2) - Saldo do usuário
- `chave_pix` (VARCHAR 255) - Chave PIX cadastrada
- `tipo_chave_pix` (ENUM) - Tipo da chave: cpf, cnpj, email, telefone, aleatorio

### Tabela `saques` (criada automaticamente)
Campos:
- `id` (INT) - ID do saque
- `user_id` (INT) - ID do usuário
- `valor` (DECIMAL 10,2) - Valor solicitado
- `status` (ENUM) - Status: pendente, processando, aprovado, rejeitado
- `created_at` (TIMESTAMP) - Data de criação
- `updated_at` (TIMESTAMP) - Data de atualização

## 🔌 APIs Criadas

### `POST /backend/save_pix.php`
Cadastra ou atualiza a chave PIX do usuário.

**Parâmetros:**
- `tipo_chave` (string) - Tipo da chave: cpf, cnpj, email, telefone, aleatorio
- `chave_pix` (string) - Chave PIX

**Validações:**
- CPF: 11 dígitos
- CNPJ: 14 dígitos
- E-mail: formato válido
- Telefone: 10-11 dígitos
- Aleatório: mínimo 30 caracteres

**Resposta:**
```json
{
  "success": true,
  "message": "Chave PIX cadastrada com sucesso",
  "data": {
    "tipo_chave": "cpf",
    "chave_pix": "12345678901"
  }
}
```

### `POST /backend/request_withdraw.php`
Solicita um saque.

**Parâmetros:**
- `valor` (float) - Valor do saque (mínimo R$ 20,00)

**Validações:**
- Valor mínimo: R$ 20,00
- Verifica saldo suficiente
- Verifica se tem chave PIX cadastrada

**Processo:**
1. Registra o saque na tabela `saques` com status "pendente"
2. Desconta o valor do saldo do usuário
3. Retorna novo saldo

**Resposta:**
```json
{
  "success": true,
  "message": "Saque solicitado com sucesso! Processaremos em até 24 horas.",
  "data": {
    "valor": 50.00,
    "novo_saldo": 150.00
  }
}
```

### `GET /backend/get_withdrawals.php`
Lista o histórico de saques do usuário (últimos 50).

**Resposta:**
```json
{
  "success": true,
  "saques": [
    {
      "id": 1,
      "valor": 50.00,
      "status": "pendente",
      "created_at": "2024-01-15 14:30:00",
      "created_at_formatted": "15/01/2024 14:30"
    }
  ]
}
```

### `GET /backend/logout.php`
Realiza logout do usuário (destrói a sessão).

**Resposta:**
```json
{
  "success": true,
  "message": "Logout realizado com sucesso"
}
```

## 🎨 Design

### Paleta de Cores
- Verde Primário: `#059669`
- Verde Secundário: `#10b981`
- Cinza Escuro: `#1f2937`
- Cinza Médio: `#6b7280`
- Cinza Claro: `#f3f4f6`

### Componentes
- Cards com gradiente verde
- Modais animados
- Inputs com foco verde
- Notificações flutuantes
- Bottom navigation com 3 itens

## 📱 Navegação

### Bottom Navigation
1. **Chats** (`/mensagem/principal/index.html`)
   - Usuários online
   - Conversas
   - Filtros por gênero

2. **Saques** (`/mensagem/saques/index.html`)
   - Saldo
   - Cadastro PIX
   - Solicitar saque
   - Histórico

3. **Perfil** (`/mensagem/perfil/index.html`)
   - Dados pessoais
   - Foto de perfil
   - Informações financeiras
   - Logout

## 🔐 Segurança

- ✅ Validação de sessão em todas as APIs
- ✅ Validação de dados no frontend e backend
- ✅ Transações com rollback em caso de erro
- ✅ Upload de imagens com validação de tipo e tamanho
- ✅ Preparação de queries SQL (PDO)

## 🚀 Próximos Passos Sugeridos

1. **Sistema de Mensagens**
   - Chat em tempo real
   - Ganho de R$ 0,35 por mensagem enviada

2. **Painel Administrativo**
   - Aprovar/rejeitar saques
   - Gerenciar usuários
   - Relatórios financeiros

3. **Notificações**
   - Push notifications
   - E-mail de confirmação de saque
   - SMS para saques aprovados

4. **Melhorias de Segurança**
   - Two-factor authentication
   - Limite de tentativas de login
   - Rate limiting nas APIs

## 📝 Notas Importantes

1. Execute o arquivo `/backend/update_table_saldo.php` UMA VEZ para adicionar os campos ao banco de dados
2. O sistema calcula 0% de taxa nos saques (pode ser modificado em `saques/script.js`)
3. Saques ficam com status "pendente" até aprovação manual
4. O histórico mostra os últimos 50 saques
