# 🎯 Integração Kwai Ads - Event API

Sistema completo de tracking para Kwai Ads implementado para rastreamento server-to-server.

## 📋 Informações da Conta

- **Pixel ID:** 294280481040524
- **Token de Teste:** 6GkdYNX1HW_KUc5nePoCkQ
- **Token Web Event:** 0OwMvfbjwazyOd_Op1jISQ5WPIfItCo2ASgVmui4I34

## 📁 Arquivos Criados

### Backend
1. **`backend/kwai_config.php`** - Configurações e credenciais da API
2. **`backend/kwai_tracking.php`** - Classe principal de tracking
3. **`backend/setup_kwai_tracking.php`** - Script para criar tabelas
4. **`backend/kwai_capture_clickid.php`** - Captura click_id da URL
5. **`backend/kwai_send_event.php`** - Envia eventos para API

### Frontend
6. **`kwai_test/index.html`** - Interface de teste
7. **`kwai_test/kwai-tracker.js`** - Helper JavaScript

## 🚀 Instalação

### 1. Criar Tabelas no Banco de Dados

Acesse no navegador:
```
http://seu-dominio.com/backend/setup_kwai_tracking.php
```

Isso criará duas tabelas:
- `kwai_tracking` - Mapeia user_id ↔ click_id
- `kwai_events_log` - Log de eventos enviados

### 2. Configurar Modo de Operação

Edite `backend/kwai_config.php`:

```php
// Para TESTES no painel Kwai (Test Events)
define('KWAI_TEST_MODE', false);
define('KWAI_TRACK_MODE', true);  // ← Mude para true

// Para PRODUÇÃO (com anúncios rodando)
define('KWAI_TEST_MODE', false);
define('KWAI_TRACK_MODE', false); // ← Mude para false
```

## 🧪 Como Testar

### 1. Testar no Painel do Kwai

1. Acesse: `http://seu-dominio.com/kwai_test/`
2. Clique em "Criar Tabelas"
3. No painel Kwai for Business:
   - Vá em "Test Events"
   - Copie o **click_id** de teste
4. Cole o click_id na interface de teste
5. Envie eventos de teste
6. Verifique no painel do Kwai se os eventos aparecem

### 2. Testar com URL Real

Simule um clique em anúncio adicionando o click_id na URL:
```
http://seu-dominio.com/autenticacao/?click_id=SEU_CLICK_ID_DE_TESTE
```

## 💻 Como Usar no Código

### Opção 1: JavaScript Helper (Recomendado)

Adicione nas suas páginas HTML:

```html
<script src="../kwai_test/kwai-tracker.js"></script>
```

Exemplos de uso:

```javascript
// Após registro completo
kwaiTracker.trackRegistration();

// Após compra
kwaiTracker.trackPurchase(150.00, 'ORDER123', [
    { id: 'PROD1', quantity: 2, price: 50.00 }
]);

// Ao iniciar checkout
kwaiTracker.trackInitiatedCheckout(150.00);

// Ao visualizar página importante
kwaiTracker.trackPageView('Homepage');

// Primeiro depósito
kwaiTracker.trackFirstDeposit(100.00);

// Evento customizado
kwaiTracker.trackCustomEvent('EVENT_CONTACT', {
    content_name: 'Formulário de Contato'
});
```

### Opção 2: Backend PHP

```php
require_once 'backend/kwai_tracking.php';

$tracking = new KwaiTracking($conn);

// Após usuário se registrar
$clickId = $tracking->getClickId($userId);
if ($clickId) {
    $tracking->trackRegistration($userId, $clickId);
}

// Após compra
$tracking->trackPurchase($userId, $clickId, 150.00, 'ORDER123');
```

## 🔄 Fluxo de Tracking

```
1. Usuário clica no anúncio Kwai
   ↓
2. Kwai redireciona com click_id na URL
   exemplo.com/?click_id=CCpgibAfpRkSWv9z...
   ↓
3. Sistema captura click_id automaticamente
   (kwai_capture_clickid.php)
   ↓
4. click_id é armazenado na sessão
   ↓
5. Usuário faz login/registro
   ↓
6. click_id é associado ao user_id no banco
   ↓
7. Eventos são enviados com o click_id
   (purchase, registration, etc.)
```

## 📊 Eventos Suportados

| Evento | Constante | Uso |
|--------|-----------|-----|
| Registro Completo | `EVENT_COMPLETE_REGISTRATION` | Após usuário completar cadastro |
| Compra | `EVENT_PURCHASE` | Após pagamento confirmado |
| Início Checkout | `EVENT_INITIATED_CHECKOUT` | Ao iniciar processo de pagamento |
| Adicionar Pagamento | `EVENT_ADD_PAYMENT_INFO` | Ao adicionar informações de pagamento |
| Visualizar Página | `EVENT_CONTENT_VIEW` | Visualização de páginas importantes |
| Primeiro Depósito | `EVENT_FIRST_DEPOSIT` | Primeiro depósito do usuário |
| Contato | `EVENT_CONTACT` | Quando usuário entra em contato |

[Ver lista completa em `kwai_config.php`]

## 🔧 Integração em Páginas Específicas

### Página de Registro (autenticacao/script.js)

```javascript
// Adicione após registro bem-sucedido:
if (typeof kwaiTracker !== 'undefined') {
    kwaiTracker.trackRegistration();
}
```

### Página de Saques (saques/script.js)

```javascript
// Após primeiro saque bem-sucedido:
if (isPrimeiroSaque && typeof kwaiTracker !== 'undefined') {
    kwaiTracker.trackFirstDeposit(valorSaque);
}
```

### Backend - Após Registro (backend/register.php)

```php
// Adicione após criar usuário com sucesso:
require_once 'kwai_tracking.php';

if (isset($_SESSION['kwai_click_id'])) {
    $tracking = new KwaiTracking($conn);
    $clickId = $_SESSION['kwai_click_id'];
    
    // Associa click_id ao usuário
    $tracking->saveClickId($userId, $clickId);
    
    // Envia evento de registro
    $tracking->trackRegistration($userId, $clickId);
}
```

## 🌐 Para Produção

Quando os anúncios estiverem rodando:

1. Edite `backend/kwai_config.php`:
   ```php
   define('KWAI_TRACK_MODE', false); // Mude para false
   ```

2. O sistema começará a rastrear automaticamente usuários que chegarem via anúncios Kwai

3. Monitore os logs em `backend/error_log` para verificar eventos enviados

## 📈 Monitoramento

Consulte eventos enviados no banco:

```sql
-- Ver todos os eventos enviados
SELECT * FROM kwai_events_log 
ORDER BY created_at DESC 
LIMIT 100;

-- Ver eventos por tipo
SELECT event_name, COUNT(*) as total, 
       SUM(success) as sucessos
FROM kwai_events_log 
GROUP BY event_name;

-- Ver usuários com click_id
SELECT u.username, k.click_id, k.updated_at
FROM kwai_tracking k
JOIN usuarios u ON k.user_id = u.id
ORDER BY k.updated_at DESC;
```

## ⚠️ Troubleshooting

### Eventos não aparecem no painel Kwai
- Verifique se `KWAI_TRACK_MODE = true` em `kwai_config.php`
- Confirme que o click_id está correto
- Verifique os logs em `backend/error_log`

### Click ID não está sendo capturado
- Verifique se a URL contém `?click_id=...`
- Confirme que o JavaScript está carregando
- Verifique a sessão PHP está funcionando

### Erro de atribuição
- Certifique-se de usar o mesmo access_token e pixel_id
- Verifique se o click_id é válido

## 📞 Suporte

Para problemas, verifique:
1. Logs do PHP em `backend/error_log`
2. Console do navegador (F12)
3. Tabela `kwai_events_log` no banco de dados

---

**Criado em:** 2025-11-04
**Versão:** 1.0.0
